<?php
require("../includes/header.php");

// appname
require_once("../config/connection.php");
$query = "SELECT appname FROM app_settings";

$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];

?>

    <title>Menu Sort - <?= $appname ?></title>
   
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.0/jquery-ui.min.js"></script>
</head>
<body>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php require("../includes/sidebar.php"); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php require("../includes/navbar.php") ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">App /</span> Menu Items</h4>
                        
                        <!-- Nav links -->
                        <ul class="nav nav-pills flex-column flex-md-row mb-3">
                            <li class="nav-item">
                                <a class="nav-link" href="./list_pages.php"><i class="bx bx-user me-1"></i> View Menu</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="add_menu.php"><i class="bx bx-bell me-1"></i> Add Menu</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link active" href="menu_sort.php"><i class="bx bx-link-alt me-1"></i> Rearrange Menu</a>
                            </li>
                        </ul>
                        <hr>
                        
                        <!-- Basic Bootstrap Table -->
                        <div class="card">
                            <div class="table-responsive text-nowrap mb-3">
                                <table id="menuTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Menu Item Name</th>
                                            <th>Order ID</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = "SELECT id, menu_name, order_id FROM app_menu WHERE is_enabled = 1 ORDER BY order_id";
                                        $result = $mysqli->query($query);

                                        if ($result && $result->num_rows > 0) {
                                            while ($row = $result->fetch_assoc()) {
                                                echo "<tr id='row_" . $row['id'] . "'>";
                                                echo "<td>" . e($row['menu_name']) . "</td>";
                                                echo "<td>" . $row['order_id'] . "</td>";
                                                echo "</tr>";
                                            }
                                        } else {
                                            echo "<tr><td colspan='2'>No data found.</td></tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <br>
                        &nbsp;&nbsp;<button class="btn btn-primary" onclick="saveOrder()">Save Order</button>
                    </div>
                    <!-- / Content -->
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- / Layout container -->
    </div>
    <!-- / Layout wrapper -->

    <script>
        $(function() {
            $("#menuTable tbody").sortable({
                update: function(event, ui) {
                    updateOrderIds();
                }
            }).disableSelection();
        });

        var reorderData = {};

        function updateOrderIds() {
            var table = document.getElementById('menuTable');
            var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
            reorderData = {}; // Reset
            for (var i = 0; i < rows.length; i++) {
                var id = rows[i].id.replace('row_', '');
                reorderData[id] = i + 1; // Adding 1 to index as order_id starts from 1
            }
        }

        function saveOrder() {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (xmlhttp.readyState == 4) {
                    if (xmlhttp.status == 200) {
                        alert("Order updated successfully!");
                        console.log(xmlhttp.responseText);
                    } else {
                        alert("Error updating order. Please try again.");
                        console.error(xmlhttp.responseText);
                    }
                }
            };
            xmlhttp.open("POST", "../functions/save_order.php", true);
            xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            
            // Add CSRF token
            var csrfToken = "<?= csrf_token(); ?>";
            xmlhttp.send("data=" + JSON.stringify(reorderData) + "&csrf_token=" + csrfToken);
        }
    </script>
   
    <script src="../assets/vendor/js/menu.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/js/main.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
</body>

</html>
